﻿<%@ Page Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="NeurobehavioralSymptomInventory.aspx.cs"
    Inherits="TBI_Instruments_NeurobehavioralSymptomInventory" Title="" %>

<%@ Import Namespace="VeteransAffairs.Registries.Business" %>

<%@ Register TagPrefix="VA" TagName="TbiDiagnosisSelector" Src="~/controls/TbiDiagnosisSelector.ascx" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        .requiredField 
        {
        	font-weight:bold;
        	color:#FF0000;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">
        <script type="text/javascript">
            Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
            Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

            function startRequest(sender, e) {
                //disable button during the AJAX call
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
            }
            function endRequest(sender, e) {
                //re-enable button once the AJAX call has completed
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
            }
        </script>

        <script type="text/javascript">
            $(document).ready(function () {
               $('input:text').keydown(function(e) {
                    //cancel enter to prevent errors
                    if (e.keyCode == 13)
                        return false;
                });

                //processPersonReporting_Click();
                //processRadioButtonQ_Click();

                window.onbeforeunload = function () {
                    //Save draft if timeout occurs
                    document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                   // return;
                }

            }); // END $(document).ready(function()

            var _inactiveTimePeriod = <%=ConfigurationManager.AppSettings["AutoSaveInactiveInSeconds"] %>; // in seconds, set in web.config

            attachEvent(window, 'load', function () {
                var _inactivetimer = $find("<%=InactiveTimer.ClientID %>");
                var idleSeconds = _inactiveTimePeriod;
                var idleTimer;
                function resetTimer() {
                     _inactivetimer._stopTimer();
                     _inactivetimer.set_interval(idleSeconds*1000);
                     _inactivetimer._startTimer();
                     
                }
                attachEvent(document.body, 'mousemove', resetTimer);
                attachEvent(document.body, 'keydown', resetTimer);
                attachEvent(document.body, 'click', resetTimer);

                resetTimer(); // Start the timer when the page loads
            });

            function attachEvent(obj, evt, fnc, useCapture) {
                if (obj.addEventListener) {
                    obj.addEventListener(evt, fnc, !!useCapture);
                    return true;
                }
                else if (obj.attachEvent) {
                    return obj.attachEvent("on" + evt, fnc);
                }
            }

            function clearRadioButtonListSelection(listName) 
            {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");

                var currIndex = GetListIndexSelected(listName);
                if (currIndex > -1) {
                    radio[currIndex].checked = false;
                }
            }

            function GetListIndexSelected(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                for (var i = 0; i < radio.length; i++) {
                    if (radio[i].checked) {
                        ret = i;
                        break;
                    }
                }

                return ret;

            } 

            function GetLastElementIndex(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                ret = radio.length - 1;

                return ret;
            }

            function btnSaveButtonChange_Click() {
                //Save draft if question 8,15,16V,28 is changed occurs
                //document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                //alert("Auto-Saving");
            }
        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" TabIndex="1" HeaderText="The page has the following data errors:"
            DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > Neurobehavioral Symptom Inventory (NSI)"
                TabIndex="2"></asp:Label>
        </div>
    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                                Processing...Please wait.
                            </div>
                        </div>
                        <%--<div style="background-color: Gray; filter: alpha(opacity=50); opacity: 0.50; width: 100%; top: 0px; left: 0px; position: fixed;
                            height: 100%;">
                        </div>
                        <div style="margin: auto; font-family: Trebuchet MS; filter: alpha(opacity=100); opacity: 1; font-size: small; vertical-align: middle;
                            top: 45%; position: fixed; right: 45%; color: #232323; text-align: center; background-color: White; height: 100px;">
                            <table style="background-color: White; font-family: Sans-Serif; text-align: center; border: solid 1px #232323; color: #232323;
                                width: 300px; height: inherit; padding: 15px;">
                                <tr>
                                    <td style="text-align: inherit;">
                                        <img src="images/loading_image.gif" alt="Loading" title="Loading Image" />
                                    </td>
                                    <td style="text-align: inherit;">
                                        <span style="font-family: Sans-Serif; font-size: medium; font-weight: bold; font">Processing...Please wait.</span>
                                    </td>
                                </tr>
                            </table>
                        </div>--%>
                        <!-- End Modal Popup for Loading -->
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:ValidationSummary ID="ValidationSummary1" runat="server" TabIndex="1" HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td>
                                &nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label
                                    ID="LabelPatient" runat="server" SkinID="DataLabel" TabIndex="2"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" TabIndex="3"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIndex="4"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="NSI" />
                <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <asp:Label ID="LabelInstrumentTitle" runat="server" Style="font-weight: bold" />&nbsp;-&nbsp;
                    <asp:LinkButton ID="lnkBtnToggleInstructions" runat="server" Text="Click for Instructions" ToolTip="Click to show/hide instructions."
                        OnClick="lnkBtnToggleInstructions_OnClick" TabIndex="5" />
                    <br />
                </asp:Panel>
                <asp:Panel ID="PanelInstructions" runat="server" Visible="false">
                    <!-- Instruction Area -->
                    <br />
                    <table style="width: 100%; border: 1px solid navy;">
                        <tr>
                            <td colspan="3">
                                <h2>
                                    Neurobehavioral Symptom Inventory (NSI)</h2>
                                <br />
                                Please rate the following symptoms with regard to how much they have disturbed you IN THE LAST 2 Weeks.
                                <br />
                                The purpose of this inventory is to track symptoms over time. Please do not attempt to score.<br />
                                <br />
                                <b>0 = None</b> – Rarely if ever present; not a problem at all
                                <br />
                                <b>1 = Mild</b> – Occasionally present, but it does not disrupt my activities; I can usually continue what I’m doing; doesn’t
                                really concern me.
                                <br />
                                <b>2 = Moderate</b> – Often present, occasionally disrupts my activities; I can usually continue what I’m doing with some
                                effort; I feel somewhat concerned.
                                <br />
                                <b>3 = Severe</b> – Frequently present and disrupts activities; I can only do things that are fairly simple or take little
                                effort; I feel I need help.
                                <br />
                                <b>4 = Very Severe</b> – Almost always present and I have been unable to perform at work, school or home due to this problem;
                                I probably cannot function without help.<br />
                                <br />
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <asp:Panel ID="PanelQuestions" Width="100%" runat="server" CssClass="mainContent">
                    <!-- Question Area -->
                    <br />
                    <table style="width: 800px; border: 1px solid navy;">
                        <tr>
                            <td style="text-align: left;">
                                <!--Date-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDate1" runat="server" AssociatedControlID="dpDate1" SkinID="DataLabel" TabIndex="10">
                                </asp:Label>
                                <!--Date picker-->
                                <telerik:RadDatePicker ID="dpDate1" runat="server" TabIndex="11">
                                    <Calendar ID="calDate1" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 1 required field validator (only one required)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDate1" TabIndex="12" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Date is required."></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td style="text-align:left;">
                                <!-- Diagnosis Control -->
                                <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                                <VA:TbiDiagnosisSelector ID="ctrlDiagnosis" runat="server" QuestionNumber="DX" StartTabIndex="13" />
                            </td>
                        </tr>
                    </table>
                    <br />
                    <table style="width: 800px; border: 1px solid navy;">
                        <tr>
                            <td colspan="2" style="text-align: left;">
                                <b>Symptoms</b>
                            </td>
                            <td style="text-align: center;">
                                <b>Rating</b>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                1.
                            </td>
                            <td style="text-align: left;">
                                <!--Feeling Dizzy-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ1" runat="server" AssociatedControlID="rblQ1" SkinID="DataLabel" TabIndex="20">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ1" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion1"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="21">
                                </asp:RadioButtonList>
                                <!--Question 1 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQuestion1" runat="server" ControlToValidate="rblQ1" TabIndex="22" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 1 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 1 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion1" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ1" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 1 Question Number--%>
                                <asp:HiddenField ID="HiddenQ1" runat="server" Visible="false" Value="1" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                2.
                            </td>
                            <td style="text-align: left;">
                                <!--Loss of Balance-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ2" runat="server" AssociatedControlID="rblQ2" SkinID="DataLabel" TabIndex="23">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ2" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion2"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="24">
                                </asp:RadioButtonList>
                                <!--Question 2 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ2" runat="server" ControlToValidate="rblQ2" TabIndex="25" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 2 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 2 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion2" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ2" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 2 Question Number--%>
                                <asp:HiddenField ID="HiddenQ2" runat="server" Visible="false" Value="2" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                3.
                            </td>
                            <td style="text-align: left;">
                                <!--Poor coordination, clumsy-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ3" runat="server" AssociatedControlID="rblQ3" SkinID="DataLabel" TabIndex="26">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ3" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion3"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="27">
                                </asp:RadioButtonList>
                                <!--Question 3 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ3" runat="server" ControlToValidate="rblQ3" TabIndex="28" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 3 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 3 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion3" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ3" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 3 Question Number--%>
                                <asp:HiddenField ID="HiddenQ3" runat="server" Visible="false" Value="3" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                4.
                            </td>
                            <td style="text-align: left;">
                                <!--Headaches-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ4" runat="server" AssociatedControlID="rblQ4" SkinID="DataLabel" TabIndex="30">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ4" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion4"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="31">
                                </asp:RadioButtonList>
                                <!--Question 4 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ4" runat="server" ControlToValidate="rblQ4" TabIndex="32" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 4 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 4 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion4" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ4" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 4 Question Number--%>
                                <asp:HiddenField ID="HiddenQ4" runat="server" Visible="false" Value="4" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                5.
                            </td>
                            <td style="text-align: left;">
                                <!--Nausea-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ5" runat="server" AssociatedControlID="rblQ5" SkinID="DataLabel" TabIndex="33">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ5" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion5"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="34">
                                </asp:RadioButtonList>
                                <!--Question 5 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ5" runat="server" ControlToValidate="rblQ5" TabIndex="35" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 5 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 5 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion5" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ5" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 5 Question Number--%>
                                <asp:HiddenField ID="HiddenQ5" runat="server" Visible="false" Value="5" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                6.
                            </td>
                            <td style="text-align: left;">
                                <!--Vision problems, blurring, trouble seeing-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ6" runat="server" AssociatedControlID="rblQ6" SkinID="DataLabel" TabIndex="36">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ6" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion6"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="37">
                                </asp:RadioButtonList>
                                <!--Question 6 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ6" runat="server" ControlToValidate="rblQ6" TabIndex="38" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 6 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 6 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion6" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ6" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 6 Question Number--%>
                                <asp:HiddenField ID="HiddenQ6" runat="server" Visible="false" Value="6" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                7.
                            </td>
                            <td style="text-align: left;">
                                <!--Sensitivity to light-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ7" runat="server" AssociatedControlID="rblQ7" SkinID="DataLabel" TabIndex="39">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ7" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion7"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="40">
                                </asp:RadioButtonList>
                                <!--Question 7 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ7" runat="server" ControlToValidate="rblQ7" TabIndex="41" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 7 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 7 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion7" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ7" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 7 Question Number--%>
                                <asp:HiddenField ID="HiddenQ7" runat="server" Visible="false" Value="7" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                8.
                            </td>
                            <td style="text-align: left;">
                                <!--Hearing difficulty-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ8" runat="server" AssociatedControlID="rblQ8" SkinID="DataLabel" TabIndex="42">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ8" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion8"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="43">
                                </asp:RadioButtonList>
                                <!--Question 8 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ8" runat="server" ControlToValidate="rblQ8" TabIndex="44" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 8 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 8 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion8" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ8" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 8 Question Number--%>
                                <asp:HiddenField ID="HiddenQ8" runat="server" Visible="false" Value="8" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                9.
                            </td>
                            <td style="text-align: left;">
                                <!--Sensitivity to noise-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ9" runat="server" AssociatedControlID="rblQ9" SkinID="DataLabel" TabIndex="45">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ9" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion9"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="46">
                                </asp:RadioButtonList>
                                <!--Question 9 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ9" runat="server" ControlToValidate="rblQ9" TabIndex="47" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 9 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 9 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion9" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ9" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 9 Question Number--%>
                                <asp:HiddenField ID="HiddenQ9" runat="server" Visible="false" Value="9" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                10.
                            </td>
                            <td style="text-align: left;">
                                <!--Numbness or tingling on parts of my body-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ10" runat="server" AssociatedControlID="rblQ10" SkinID="DataLabel" TabIndex="48">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ10" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion10"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="49">
                                </asp:RadioButtonList>
                                <!--Question 10 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ10" runat="server" ControlToValidate="rblQ10" TabIndex="50" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 10 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 10 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion10" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ10" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 10 Question Number--%>
                                <asp:HiddenField ID="HiddenQ10" runat="server" Visible="false" Value="10" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                11.
                            </td>
                            <td style="text-align: left;">
                                <!--Change in taste and/or smell-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ11" runat="server" AssociatedControlID="rblQ11" SkinID="DataLabel" TabIndex="51">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ11" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion11"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="52">
                                </asp:RadioButtonList>
                                <!--Question 11 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ11" runat="server" ControlToValidate="rblQ11" TabIndex="53" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 11 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 11 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion11" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ11" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 11 Question Number--%>
                                <asp:HiddenField ID="HiddenQ11" runat="server" Visible="false" Value="11" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                12.
                            </td>
                            <td style="text-align: left;">
                                <!--Loss of appetite or increased appetite-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ12" runat="server" AssociatedControlID="rblQ12" SkinID="DataLabel" TabIndex="54">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ12" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion12"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="55">
                                </asp:RadioButtonList>
                                <!--Question 12 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ12" runat="server" ControlToValidate="rblQ12" TabIndex="56" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 12 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 12 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion12" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ12" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 12 Question Number--%>
                                <asp:HiddenField ID="HiddenQ12" runat="server" Visible="false" Value="12" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                13.
                            </td>
                            <td style="text-align: left;">
                                <!--Poor concentration, can’t pay attention, easily distracted-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ13" runat="server" AssociatedControlID="rblQ13" SkinID="DataLabel" TabIndex="57">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ13" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion13"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="58">
                                </asp:RadioButtonList>
                                <!--Question 13 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ13" runat="server" ControlToValidate="rblQ13" TabIndex="59" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 13 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 13 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion13" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ13" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 13 Question Number--%>
                                <asp:HiddenField ID="HiddenQ13" runat="server" Visible="false" Value="13" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                14.
                            </td>
                            <td style="text-align: left;">
                                <!--Forgetfulness, can’t remember things-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ14" runat="server" AssociatedControlID="rblQ14" SkinID="DataLabel" TabIndex="60">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ14" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion14"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="61">
                                </asp:RadioButtonList>
                                <!--Question 14 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ14" runat="server" ControlToValidate="rblQ14" TabIndex="62" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 14 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 14 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion14" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ14" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 14 Question Number--%>
                                <asp:HiddenField ID="HiddenQ14" runat="server" Visible="false" Value="14" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                15.
                            </td>
                            <td style="text-align: left;">
                                <!--Difficulty making decisions-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ15" runat="server" AssociatedControlID="rblQ15" SkinID="DataLabel" TabIndex="63">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ15" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion15"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="64">
                                </asp:RadioButtonList>
                                <!--Question 15 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ15" runat="server" ControlToValidate="rblQ15" TabIndex="65" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 15 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 15 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion15" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ15" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 15 Question Number--%>
                                <asp:HiddenField ID="HiddenQ15" runat="server" Visible="false" Value="15" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                16.
                            </td>
                            <td style="text-align: left;">
                                <!--Slowed thinking, difficulty getting organized, can’t finish things-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ16" runat="server" AssociatedControlID="rblQ16" SkinID="DataLabel" TabIndex="66">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ16" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion16"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="67">
                                </asp:RadioButtonList>
                                <!--Question 16 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ16" runat="server" ControlToValidate="rblQ16" TabIndex="68" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 16 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 16 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion16" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ16" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 16 Question Number--%>
                                <asp:HiddenField ID="HiddenQ16" runat="server" Visible="false" Value="16" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                17.
                            </td>
                            <td style="text-align: left;">
                                <!--Fatigue, loss of energy, getting tired easily-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ17" runat="server" AssociatedControlID="rblQ17" SkinID="DataLabel" TabIndex="69">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ17" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion17"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="70">
                                </asp:RadioButtonList>
                                <!--Question 17 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ17" runat="server" ControlToValidate="rblQ17" TabIndex="71" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 17 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 17 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion17" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ17" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 17 Question Number--%>
                                <asp:HiddenField ID="HiddenQ17" runat="server" Visible="false" Value="17" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                18.
                            </td>
                            <td style="text-align: left;">
                                <!--Difficulty falling or staying asleep-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ18" runat="server" AssociatedControlID="rblQ18" SkinID="DataLabel" TabIndex="72">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ18" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion18"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="73">
                                </asp:RadioButtonList>
                                <!--Question 18 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ18" runat="server" ControlToValidate="rblQ18" TabIndex="74" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 18 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 18 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion18" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ18" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 18 Question Number--%>
                                <asp:HiddenField ID="HiddenQ18" runat="server" Visible="false" Value="18" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                19.
                            </td>
                            <td style="text-align: left;">
                                <!--Feeling anxious or tense-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ19" runat="server" AssociatedControlID="rblQ19" SkinID="DataLabel" TabIndex="75">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ19" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion19"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="76">
                                </asp:RadioButtonList>
                                <!--Question 19 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ19" runat="server" ControlToValidate="rblQ19" TabIndex="77" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 19 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 19 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion19" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ19" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 19 Question Number--%>
                                <asp:HiddenField ID="HiddenQ19" runat="server" Visible="false" Value="19" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                20.
                            </td>
                            <td style="text-align: left;">
                                <!--Feeling depressed or sad-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ20" runat="server" AssociatedControlID="rblQ20" SkinID="DataLabel" TabIndex="78">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ20" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion20"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="79">
                                </asp:RadioButtonList>
                                <!--Question 20 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ20" runat="server" ControlToValidate="rblQ20" TabIndex="80" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 20 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 20 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion20" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ20" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 20 Question Number--%>
                                <asp:HiddenField ID="HiddenQ20" runat="server" Visible="false" Value="20" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                21.
                            </td>
                            <td style="text-align: left;">
                                <!--Irritability, easily annoyed-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ21" runat="server" AssociatedControlID="rblQ21" SkinID="DataLabel" TabIndex="81">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ21" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion21"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="82">
                                </asp:RadioButtonList>
                                <!--Question 21 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ21" runat="server" ControlToValidate="rblQ21" TabIndex="83" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 21 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 21 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion21" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ21" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 21 Question Number--%>
                                <asp:HiddenField ID="HiddenQ21" runat="server" Visible="false" Value="21" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                22.
                            </td>
                            <td style="text-align: left;">
                                <!--Poor frustration tolerance, feeling easily overwhelmed by things-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ22" runat="server" AssociatedControlID="rblQ22" SkinID="DataLabel" TabIndex="84">
                                </asp:Label>
                            </td>
                            <td style="text-align: right; width: 200px;">
                                <asp:RadioButtonList ID="rblQ22" runat="server" RepeatDirection="Horizontal" Width="200px" DataSourceID="ObjectDataSourceQuestion22"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="85">
                                </asp:RadioButtonList>
                                <!--Question 22 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ22" runat="server" ControlToValidate="rblQ22" TabIndex="86" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Question 22 selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 22 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion22" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ22" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 22 Question Number--%>
                                <asp:HiddenField ID="HiddenQ22" runat="server" Visible="false" Value="22" />
                            </td>
                        </tr>
                    </table>
                    <p style="font-style:italic;">
                        Information collected in this instrument is not sufficient to use alone for diagnostic purposes.  Any assessment results need to be verified by the clinician collecting the data for accuracy and used in conjunction with appropriate clinical tools for developing a diagnosis and an individualized treatment plan.
                    </p>
                    <!-- End Question Area -->
                    <br />
                </asp:Panel>
                <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
                    <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                </telerik:RadAjaxPanel>
                <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" Text="Save Draft" Width="130px" OnClick="btnSaveSurveyDraft_Click"
                    ValidationGroup="OnSaveDraft" TabIndex="87" />
                <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note" Width="180px" OnClick="btnSubmit_Click"
                    ValidationGroup="OnSave" TabIndex="88" />
                <asp:Button ID="btnCancelSurvey" runat="server" TabIndex="89" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>
